/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.nodes;

import com.aptana.editor.js.formatter.nodes.FormatterJSTextNode;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.NodeTypes;

public class FormatterJSOperatorNode
extends FormatterJSTextNode {
    private final NodeTypes.TypeOperator nodeType;
    private boolean isUnary;

    public FormatterJSOperatorNode(IFormatterDocument document, NodeTypes.TypeOperator nodeType, boolean isUnary, boolean hasCommentBefore) {
        super(document, true, hasCommentBefore);
        this.nodeType = nodeType;
        this.isUnary = isUnary;
    }

    protected boolean isAddingBeginNewLine() {
        return this.nodeType == NodeTypes.TypeOperator.DELETE || this.nodeType == NodeTypes.TypeOperator.VOID;
    }

    public int getSpacesCountBefore() {
        if (this.isUnary) {
            switch (this.nodeType) {
                case TYPEOF: 
                case DELETE: 
                case VOID: {
                    return Math.max(1, this.getDocument().getInt("js.formatter.spaces.before.unary.operator"));
                }
            }
            return this.getDocument().getInt("js.formatter.spaces.before.unary.operator");
        }
        switch (this.nodeType) {
            case KEY_VALUE_COLON: {
                return this.getDocument().getInt("js.formatter.spaces.before.key.value.operator");
            }
            case ASSIGNMENT: 
            case DOT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case MULTIPLY_EQUAL: 
            case DIVIDE_EQUAL: 
            case TILDE_EQUAL: 
            case MODULUS_EQUAL: 
            case XOR_EQUAL: 
            case OR_EQUAL: 
            case AND_EQUAL: 
            case SHIFT_RIGHT: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT_ASSIGN: 
            case SHIFT_LEFT_ASSIGN: 
            case SHIFT_RIGHT_ZERO_FILL: 
            case SHIFT_RIGHT_ZERO_FILL_ASSIGN: {
                return this.getDocument().getInt("js.formatter.spaces.before.assignment.operator");
            }
            case GREATER_THAN: 
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case EQUAL: 
            case IDENTICAL: 
            case NOT_EQUAL: 
            case NOT_EQUAL_ALTERNATE: 
            case NOT_IDENTICAL: {
                return this.getDocument().getInt("js.formatter.spaces.before.relational.operator");
            }
            case IN: 
            case INSTANCOF: {
                return Math.max(1, this.getDocument().getInt("js.formatter.spaces.before.relational.operator"));
            }
            case PLUS_CONCATENATION: {
                return this.getDocument().getInt("js.formatter.spaces.before.concatenation.operator");
            }
            case CONDITIONAL: 
            case CONDITIONAL_COLON: {
                return this.getDocument().getInt("js.formatter.spaces.before.conditional.operator");
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                return this.getDocument().getInt("js.formatter.spaces.before.postfix.operator");
            }
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: {
                return this.getDocument().getInt("js.formatter.spaces.before.prefix.operator");
            }
            case MULTIPLY: 
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULUS: 
            case OR: 
            case AND: 
            case XOR: 
            case BINARY_OR: 
            case BINARY_AND: {
                return this.getDocument().getInt("js.formatter.spaces.before.arithmetic.operator");
            }
            case OR_LITERAL: 
            case AND_LITERAL: 
            case XOR_LITERAL: {
                return Math.max(1, this.getDocument().getInt("js.formatter.spaces.before.arithmetic.operator"));
            }
            case TILDE: 
            case NOT: {
                return this.getDocument().getInt("js.formatter.spaces.before.unary.operator");
            }
        }
        return super.getSpacesCountBefore();
    }

    public int getSpacesCountAfter() {
        if (this.isUnary) {
            switch (this.nodeType) {
                case TYPEOF: 
                case DELETE: 
                case VOID: {
                    return Math.max(1, this.getDocument().getInt("js.formatter.spaces.before.unary.operator"));
                }
            }
            return this.getDocument().getInt("js.formatter.spaces.after.unary.operator");
        }
        switch (this.nodeType) {
            case KEY_VALUE_COLON: {
                return this.getDocument().getInt("js.formatter.spaces.after.key.value.operator");
            }
            case ASSIGNMENT: 
            case DOT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case MULTIPLY_EQUAL: 
            case DIVIDE_EQUAL: 
            case TILDE_EQUAL: 
            case MODULUS_EQUAL: 
            case OR_EQUAL: 
            case AND_EQUAL: 
            case SHIFT_RIGHT: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT_ASSIGN: 
            case SHIFT_LEFT_ASSIGN: 
            case SHIFT_RIGHT_ZERO_FILL: 
            case SHIFT_RIGHT_ZERO_FILL_ASSIGN: {
                return this.getDocument().getInt("js.formatter.spaces.after.assignment.operator");
            }
            case GREATER_THAN: 
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case EQUAL: 
            case IDENTICAL: 
            case NOT_EQUAL: 
            case NOT_EQUAL_ALTERNATE: 
            case NOT_IDENTICAL: {
                return this.getDocument().getInt("js.formatter.spaces.after.relational.operator");
            }
            case IN: 
            case INSTANCOF: {
                return Math.max(1, this.getDocument().getInt("js.formatter.spaces.after.relational.operator"));
            }
            case PLUS_CONCATENATION: {
                return this.getDocument().getInt("js.formatter.spaces.after.concatenation.operator");
            }
            case CONDITIONAL: 
            case CONDITIONAL_COLON: {
                return this.getDocument().getInt("js.formatter.spaces.after.conditional.operator");
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                return this.getDocument().getInt("js.formatter.spaces.after.postfix.operator");
            }
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: {
                return this.getDocument().getInt("js.formatter.spaces.after.prefix.operator");
            }
            case MULTIPLY: 
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULUS: 
            case OR: 
            case AND: 
            case XOR: 
            case BINARY_OR: 
            case BINARY_AND: {
                return this.getDocument().getInt("js.formatter.spaces.after.arithmetic.operator");
            }
            case OR_LITERAL: 
            case AND_LITERAL: 
            case XOR_LITERAL: {
                return Math.max(1, this.getDocument().getInt("js.formatter.spaces.after.arithmetic.operator"));
            }
            case TILDE: 
            case NOT: {
                return this.getDocument().getInt("js.formatter.spaces.after.unary.operator");
            }
            case TYPEOF: 
            case DELETE: 
            case VOID: {
                return Math.max(1, this.getDocument().getInt("js.formatter.spaces.after.unary.operator"));
            }
        }
        return super.getSpacesCountBefore();
    }
}

